/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.thumbnails4j.image;

import co.elastic.thumbnails4j.core.Dimensions;
import co.elastic.thumbnails4j.core.ThumbnailUtils;
import co.elastic.thumbnails4j.core.Thumbnailer;
import co.elastic.thumbnails4j.core.ThumbnailingException;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageThumbnailer
implements Thumbnailer {
    public static int MAX_READ_MULTIPLIER = 4;
    private static final Logger logger = LoggerFactory.getLogger(ImageThumbnailer.class);
    private final int imageType;

    public ImageThumbnailer(String thumbnailType) {
        this.imageType = thumbnailType.equalsIgnoreCase("png") ? 2 : 1;
    }

    public List<BufferedImage> getThumbnails(File input, List<Dimensions> dimensions) throws ThumbnailingException {
        return this.getThumbnailsHelper(input, dimensions);
    }

    public List<BufferedImage> getThumbnails(InputStream input, List<Dimensions> dimensions) throws ThumbnailingException {
        return this.getThumbnailsHelper(input, dimensions);
    }

    private List<BufferedImage> getThumbnailsHelper(Object input, List<Dimensions> dimensions) throws ThumbnailingException {
        BufferedImage image;
        try {
            image = this.imageAtMost(input, ImageThumbnailer.maxImageReadSize());
        }
        catch (IOException e) {
            logger.error("Failed to read image from file {}", input);
            logger.error("With stacktrace: ", (Throwable)e);
            throw new ThumbnailingException((Exception)e);
        }
        ArrayList<BufferedImage> output = new ArrayList<BufferedImage>();
        for (Dimensions singleDimension : dimensions) {
            output.add(ThumbnailUtils.scaleImage((BufferedImage)image, (Dimensions)singleDimension, (int)this.imageType));
        }
        return output;
    }

    private BufferedImage imageAtMost(Object input, Dimensions dimensions) throws IOException, ThumbnailingException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ImageInputStream stream = ImageIO.createImageInputStream(input);){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(stream);
            if (!readers.hasNext()) {
                throw new ThumbnailingException("Image stream contained no images");
            }
            ImageReader reader = readers.next();
            reader.setInput(stream);
            ImageReadParam param = reader.getDefaultReadParam();
            param.setSourceRegion(new Rectangle(0, 0, dimensions.getWidth(), dimensions.getHeight()));
            BufferedImage image = reader.read(0, param);
            reader.dispose();
            return image;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static Dimensions maxImageReadSize() {
        return new Dimensions(ThumbnailUtils.getMaxInMemoryBuffer().getWidth() * MAX_READ_MULTIPLIER, ThumbnailUtils.getMaxInMemoryBuffer().getHeight() * MAX_READ_MULTIPLIER);
    }
}

