/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.rack.embed;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.rack.DefaultRackConfig;
import org.jruby.rack.RackConfig;
import org.jruby.rack.RackLogger;

public class Config
implements RackConfig {
    private final DefaultRackConfig delegate = new DefaultRackConfig(){

        @Override
        public String getProperty(String key, String defaultValue) {
            String value = Config.this.resolveProperty(key);
            return value != null ? value : super.getProperty(key, defaultValue);
        }

        @Override
        public RackLogger defaultLogger() {
            return null;
        }
    };
    private RackLogger logger;
    private Map<String, String> rubyENV;
    private CompatVersion compatVersion;

    void doInitialize(Ruby runtime) {
        this.setOut(runtime.getOut());
        this.setErr(runtime.getErr());
        this.rubyENV = runtime.getENV();
        this.compatVersion = runtime.getInstanceConfig().getCompatVersion();
    }

    protected String resolveProperty(String key) {
        String value = null;
        if (this.rubyENV != null) {
            value = this.rubyENV.get(key);
        }
        return value;
    }

    @Override
    public final String getProperty(String key) {
        return this.delegate.getProperty(key);
    }

    @Override
    public final String getProperty(String key, String defaultValue) {
        return this.delegate.getProperty(key, defaultValue);
    }

    @Override
    public final Boolean getBooleanProperty(String key) {
        return this.delegate.getBooleanProperty(key);
    }

    @Override
    public final Boolean getBooleanProperty(String key, Boolean defaultValue) {
        return this.delegate.getBooleanProperty(key, defaultValue);
    }

    @Override
    public final Number getNumberProperty(String key) {
        return this.delegate.getNumberProperty(key);
    }

    @Override
    public final Number getNumberProperty(String key, Number defaultValue) {
        return this.delegate.getNumberProperty(key, defaultValue);
    }

    @Override
    public CompatVersion getCompatVersion() {
        return this.compatVersion;
    }

    @Override
    public RackLogger getLogger() {
        if (this.logger == null) {
            this.logger = this.delegate.getLogger();
        }
        return this.logger;
    }

    public void setLogger(RackLogger logger) {
        this.logger = logger;
    }

    @Override
    public PrintStream getOut() {
        return this.delegate.getOut();
    }

    public void setOut(OutputStream out) {
        this.delegate.setOut(out);
    }

    @Override
    public PrintStream getErr() {
        return this.delegate.getErr();
    }

    public void setErr(OutputStream err) {
        this.delegate.setErr(err);
    }

    @Override
    public boolean isRewindable() {
        return this.delegate.isRewindable();
    }

    @Override
    public Integer getInitialMemoryBufferSize() {
        return this.delegate.getInitialMemoryBufferSize();
    }

    @Override
    public Integer getMaximumMemoryBufferSize() {
        return this.delegate.getMaximumMemoryBufferSize();
    }

    @Override
    public String getRackup() {
        return this.delegate.getRackup();
    }

    @Override
    public String getRackupPath() {
        return this.delegate.getRackupPath();
    }

    @Override
    public Integer getRuntimeTimeoutSeconds() {
        throw new UnsupportedOperationException("getRuntimeTimeoutSeconds()");
    }

    @Override
    public Integer getInitialRuntimes() {
        throw new UnsupportedOperationException("getInitialRuntimes()");
    }

    @Override
    public Integer getMaximumRuntimes() {
        throw new UnsupportedOperationException("getMaximumRuntimes()");
    }

    @Override
    public String[] getRuntimeArguments() {
        throw new UnsupportedOperationException("getRuntimeArguments()");
    }

    @Override
    public Integer getNumInitializerThreads() {
        throw new UnsupportedOperationException("getNumInitializerThreads()");
    }

    @Override
    public boolean isSerialInitialization() {
        throw new UnsupportedOperationException("isSerialInitialization()");
    }

    @Override
    public boolean isIgnoreEnvironment() {
        throw new UnsupportedOperationException("isIgnoreEnvironment()");
    }

    @Override
    public Map<String, String> getRuntimeEnvironment() {
        throw new UnsupportedOperationException("getRuntimeEnvironment()");
    }

    @Override
    public boolean isFilterAddsHtml() {
        throw new UnsupportedOperationException("isFilterAddsHtml()");
    }

    @Override
    public boolean isFilterVerifiesResource() {
        throw new UnsupportedOperationException("isFilterVerifiesResource()");
    }

    @Override
    public String getJmsConnectionFactory() {
        throw new UnsupportedOperationException("getJmsConnectionFactory()");
    }

    @Override
    public String getJmsJndiProperties() {
        throw new UnsupportedOperationException("getJmsJndiProperties()");
    }
}

