/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datageneration.matchers;

import java.util.Arrays;
import java.util.List;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.datageneration.matchers.GenericEqualsMatcher;
import org.elasticsearch.datageneration.matchers.MatchResult;
import org.elasticsearch.datageneration.matchers.Messages;
import org.elasticsearch.xcontent.XContentBuilder;

class ArrayEqualMatcher
extends GenericEqualsMatcher<Object[]> {
    ArrayEqualMatcher(XContentBuilder actualMappings, Settings.Builder actualSettings, XContentBuilder expectedMappings, Settings.Builder expectedSettings, Object[] actual, Object[] expected, boolean ignoringSort) {
        super(actualMappings, actualSettings, expectedMappings, expectedSettings, actual, expected, ignoringSort);
    }

    @Override
    public MatchResult match() {
        return this.matchArraysEqual((Object[])this.actual, (Object[])this.expected, this.ignoringSort);
    }

    private MatchResult matchArraysEqual(Object[] actualArray, Object[] expectedArray, boolean ignoreSorting) {
        if (actualArray.length != expectedArray.length) {
            return MatchResult.noMatch(Messages.formatErrorMessage(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, "Array lengths do no match, " + Messages.prettyPrintArrays(actualArray, expectedArray)));
        }
        if (ignoreSorting) {
            return ArrayEqualMatcher.matchArraysEqualIgnoringSorting(actualArray, expectedArray) ? MatchResult.match() : MatchResult.noMatch(Messages.formatErrorMessage(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, "Arrays do not match when ignoring sort order, " + Messages.prettyPrintArrays(actualArray, expectedArray)));
        }
        return ArrayEqualMatcher.matchArraysEqualExact(actualArray, expectedArray) ? MatchResult.match() : MatchResult.noMatch(Messages.formatErrorMessage(this.actualMappings, this.actualSettings, this.expectedMappings, this.expectedSettings, "Arrays do not match exactly, " + Messages.prettyPrintArrays(actualArray, expectedArray)));
    }

    private static boolean matchArraysEqualIgnoringSorting(Object[] actualArray, Object[] expectedArray) {
        List<Object> expectedList;
        List<Object> actualList = Arrays.asList(actualArray);
        return actualList.containsAll(expectedList = Arrays.asList(expectedArray)) && expectedList.containsAll(actualList);
    }

    private static <T> boolean matchArraysEqualExact(T[] actualArray, T[] expectedArray) {
        for (int i = 0; i < actualArray.length; ++i) {
            boolean isEqual = actualArray[i].equals(expectedArray[i]);
            if (isEqual) continue;
            return false;
        }
        return true;
    }
}

