/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.string.regex;

import java.io.IOException;
import org.apache.lucene.util.automaton.Automata;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.capabilities.TranslationAware;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.predicate.regex.AbstractStringPattern;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.AutomataMatch;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.local.LucenePushdownPredicates;

abstract class RegexMatch<P extends AbstractStringPattern>
extends org.elasticsearch.xpack.esql.core.expression.predicate.regex.RegexMatch<P>
implements EvaluatorMapper,
TranslationAware.SingleValueTranslationAware {
    private static final TransportVersion ESQL_REGEX_MATCH_WITH_CASE_INSENSITIVITY = TransportVersion.fromName((String)"esql_regex_match_with_case_insensitivity");

    abstract String name();

    RegexMatch(Source source, Expression field, P pattern, boolean caseInsensitive) {
        super(source, field, pattern, caseInsensitive);
    }

    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isString((Expression)this.field(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
    }

    public Boolean fold(FoldContext ctx) {
        return (Boolean)EvaluatorMapper.super.fold(this.source(), ctx);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        return AutomataMatch.toEvaluator(this.source(), toEvaluator.apply(this.field()), ((AbstractStringPattern)this.pattern()).pattern().isEmpty() ? Automata.makeEmptyString() : ((AbstractStringPattern)this.pattern()).createAutomaton(this.caseInsensitive()));
    }

    @Override
    public TranslationAware.Translatable translatable(LucenePushdownPredicates pushdownPredicates) {
        return pushdownPredicates.isPushableFieldAttribute(this.field()) ? TranslationAware.Translatable.YES : TranslationAware.Translatable.NO;
    }

    @Override
    public Expression singleValueField() {
        return this.field();
    }

    public String nodeString() {
        return this.name() + "(" + this.field().nodeString() + ", \"" + ((AbstractStringPattern)this.pattern()).pattern() + "\", " + this.caseInsensitive() + ")";
    }

    void serializeCaseInsensitivity(StreamOutput out) throws IOException {
        if (!out.getTransportVersion().supports(ESQL_REGEX_MATCH_WITH_CASE_INSENSITIVITY)) {
            if (this.caseInsensitive()) {
                throw new EsqlIllegalArgumentException(this.name() + " with case insensitivity is not supported in peer node's version [{}]. Upgrade to version [{}] or newer.", out.getTransportVersion(), ESQL_REGEX_MATCH_WITH_CASE_INSENSITIVITY);
            }
        } else {
            out.writeBoolean(this.caseInsensitive());
        }
    }

    static boolean deserializeCaseInsensitivity(StreamInput in) throws IOException {
        return in.getTransportVersion().supports(ESQL_REGEX_MATCH_WITH_CASE_INSENSITIVITY) && in.readBoolean();
    }
}

