/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.settings;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.Index;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.settings.GetSecuritySettingsAction;
import org.elasticsearch.xpack.core.security.action.settings.UpdateSecuritySettingsAction;

public class TransportGetSecuritySettingsAction
extends TransportMasterNodeAction<GetSecuritySettingsAction.Request, GetSecuritySettingsAction.Response> {
    @Inject
    public TransportGetSecuritySettingsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters) {
        super(GetSecuritySettingsAction.INSTANCE.name(), transportService, clusterService, threadPool, actionFilters, GetSecuritySettingsAction.Request::readFrom, GetSecuritySettingsAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
    }

    protected void masterOperation(Task task, GetSecuritySettingsAction.Request request, ClusterState state, ActionListener<GetSecuritySettingsAction.Response> listener) {
        listener.onResponse((Object)new GetSecuritySettingsAction.Response(TransportGetSecuritySettingsAction.getFilteredSettingsForIndex(".security", state), TransportGetSecuritySettingsAction.getFilteredSettingsForIndex(".security-tokens", state), TransportGetSecuritySettingsAction.getFilteredSettingsForIndex(".security-profile", state)));
    }

    private static Settings getFilteredSettingsForIndex(String indexName, ClusterState state) {
        return TransportGetSecuritySettingsAction.resolveConcreteIndex(indexName, state).map(idx -> state.metadata().index(idx)).map(IndexMetadata::getSettings).map(settings -> {
            Settings.Builder builder = Settings.builder();
            for (String settingName : UpdateSecuritySettingsAction.ALLOWED_SETTING_VALIDATORS.keySet()) {
                if (!settings.hasValue(settingName)) continue;
                builder.put(settingName, settings.get(settingName));
            }
            return builder.build();
        }).orElse(Settings.EMPTY);
    }

    static Optional<Index> resolveConcreteIndex(String indexAbstractionName, ClusterState state) {
        IndexAbstraction abstraction = (IndexAbstraction)state.metadata().getIndicesLookup().get(indexAbstractionName);
        if (abstraction == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(abstraction.getWriteIndex());
    }

    static String[] resolveConcreteIndices(List<String> indexAbstractionNames, ClusterState state) {
        return (String[])indexAbstractionNames.stream().map(alias -> TransportGetSecuritySettingsAction.resolveConcreteIndex(alias, state).map(Index::getName)).filter(Optional::isPresent).map(Optional::get).toArray(String[]::new);
    }

    protected ClusterBlockException checkBlock(GetSecuritySettingsAction.Request request, ClusterState state) {
        ClusterBlockException globalBlock = state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
        if (globalBlock != null) {
            return globalBlock;
        }
        String[] indices = TransportGetSecuritySettingsAction.resolveConcreteIndices(List.of(".security", ".security-tokens", ".security-profile"), state);
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, indices);
    }
}

