/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle;

import java.io.File;
import javax.inject.Inject;
import org.elasticsearch.gradle.ReaperService;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.provider.Provider;

public class ReaperPlugin
implements Plugin<Project> {
    public static final String REAPER_SERVICE_NAME = "reaper";
    private final ProjectLayout projectLayout;

    @Inject
    ReaperPlugin(ProjectLayout projectLayout) {
        this.projectLayout = projectLayout;
    }

    public void apply(Project project) {
        ReaperPlugin.registerReaperService(project, this.projectLayout, false);
    }

    public static void registerReaperService(Project project, ProjectLayout projectLayout, boolean internal) {
        if (project != project.getRootProject()) {
            throw new IllegalArgumentException("ReaperPlugin can only be applied to the root project of a build");
        }
        File inputDir = projectLayout.getProjectDirectory().dir(".gradle").dir(REAPER_SERVICE_NAME).dir("build-" + ProcessHandle.current().pid()).getAsFile();
        project.getGradle().getSharedServices().registerIfAbsent(REAPER_SERVICE_NAME, ReaperService.class, spec -> {
            ((ReaperService.Params)spec.getParameters()).getInputDir().set(inputDir);
            ((ReaperService.Params)spec.getParameters()).getBuildDir().set((Provider)projectLayout.getBuildDirectory());
            ((ReaperService.Params)spec.getParameters()).setInternal(internal);
        });
    }
}

