/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reservedstate.service;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.coordination.FailedToCommitClusterStateException;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ReservedStateMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.file.MasterNodeFileWatchingService;
import org.elasticsearch.env.Environment;
import org.elasticsearch.reservedstate.service.ReservedClusterStateService;
import org.elasticsearch.reservedstate.service.ReservedStateVersionCheck;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class FileSettingsService
extends MasterNodeFileWatchingService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(FileSettingsService.class);
    public static final String SETTINGS_FILE_NAME = "settings.json";
    public static final String NAMESPACE = "file_settings";
    public static final String OPERATOR_DIRECTORY = "operator";
    private final ReservedClusterStateService stateService;

    public FileSettingsService(ClusterService clusterService, ReservedClusterStateService stateService, Environment environment) {
        super(clusterService, environment.configDir().toAbsolutePath().resolve(OPERATOR_DIRECTORY).resolve(SETTINGS_FILE_NAME));
        this.stateService = stateService;
    }

    public void handleSnapshotRestore(ClusterState clusterState, Metadata.Builder mdBuilder) {
        assert (clusterState.nodes().isLocalNodeElectedMaster());
        ReservedStateMetadata fileSettingsMetadata = clusterState.metadata().reservedStateMetadata().get(NAMESPACE);
        if (this.watching() && this.filesExists(this.watchedFile())) {
            if (fileSettingsMetadata != null) {
                ReservedStateMetadata withResetVersion = new ReservedStateMetadata.Builder(fileSettingsMetadata).version(0L).build();
                mdBuilder.put(withResetVersion);
            }
        } else if (fileSettingsMetadata != null) {
            mdBuilder.removeReservedState(fileSettingsMetadata);
        }
    }

    @Override
    protected boolean shouldRefreshFileState(ClusterState clusterState) {
        ReservedStateMetadata fileSettingsMetadata = clusterState.metadata().reservedStateMetadata().get(NAMESPACE);
        return fileSettingsMetadata != null && fileSettingsMetadata.version().equals(ReservedStateMetadata.RESTORED_VERSION);
    }

    @Override
    protected void processFileChanges() throws ExecutionException, InterruptedException, IOException {
        logger.info("processing path [{}] for [{}]", (Object)this.watchedFile(), (Object)NAMESPACE);
        this.processFileChanges(ReservedStateVersionCheck.HIGHER_VERSION_ONLY);
    }

    @Override
    protected void processFileOnServiceStart() throws IOException, ExecutionException, InterruptedException {
        logger.info("processing path [{}] for [{}] on service start", (Object)this.watchedFile(), (Object)NAMESPACE);
        this.processFileChanges(ReservedStateVersionCheck.HIGHER_OR_SAME_VERSION);
    }

    private void processFileChanges(ReservedStateVersionCheck versionCheck) throws IOException, InterruptedException, ExecutionException {
        PlainActionFuture completion = new PlainActionFuture();
        try (InputStream fis = this.filesNewInputStream(this.watchedFile());
             BufferedInputStream bis = new BufferedInputStream(fis);
             XContentParser parser = XContentType.JSON.xContent().createParser(XContentParserConfiguration.EMPTY, (InputStream)bis);){
            this.stateService.process(NAMESPACE, parser, versionCheck, e -> FileSettingsService.completeProcessing(e, completion));
        }
        completion.get();
    }

    @Override
    protected void onProcessFileChangesException(Exception e) {
        Throwable throwable;
        if (e instanceof ExecutionException && (throwable = e.getCause()) instanceof FailedToCommitClusterStateException) {
            FailedToCommitClusterStateException f = (FailedToCommitClusterStateException)throwable;
            logger.error("Unable to commit cluster state", (Throwable)e);
        } else {
            super.onProcessFileChangesException(e);
        }
    }

    @Override
    protected void processInitialFileMissing() throws ExecutionException, InterruptedException, IOException {
        PlainActionFuture<ActionResponse.Empty> completion = new PlainActionFuture<ActionResponse.Empty>();
        logger.info("setting file [{}] not found, initializing [{}] as empty", (Object)this.watchedFile(), (Object)NAMESPACE);
        this.stateService.initEmpty(NAMESPACE, completion);
        completion.get();
    }

    private static void completeProcessing(Exception e, PlainActionFuture<Void> completion) {
        if (e != null) {
            completion.onFailure(e);
        } else {
            completion.onResponse(null);
        }
    }

    @Override
    protected boolean filesExists(Path path) {
        return Files.exists(path, new LinkOption[0]);
    }

    @Override
    protected boolean filesIsDirectory(Path path) {
        return Files.isDirectory(path, new LinkOption[0]);
    }

    @Override
    protected <A extends BasicFileAttributes> A filesReadAttributes(Path path, Class<A> clazz) throws IOException {
        return Files.readAttributes(path, clazz, new LinkOption[0]);
    }

    @Override
    protected Stream<Path> filesList(Path dir) throws IOException {
        return Files.list(dir);
    }

    @Override
    protected Path filesSetLastModifiedTime(Path path, FileTime time) throws IOException {
        return Files.setLastModifiedTime(path, time);
    }

    @Override
    protected InputStream filesNewInputStream(Path path) throws IOException {
        return Files.newInputStream(path, new OpenOption[0]);
    }
}

