/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.TransportRequest;

public abstract class RecoveryTransportRequest
extends TransportRequest {
    private final long requestSeqNo;
    private final long recoveryId;
    private final ShardId shardId;

    RecoveryTransportRequest(StreamInput in) throws IOException {
        super(in);
        this.requestSeqNo = in.readLong();
        this.recoveryId = in.readLong();
        this.shardId = new ShardId(in);
    }

    RecoveryTransportRequest(long requestSeqNo, long recoveryId, ShardId shardId) {
        this.requestSeqNo = requestSeqNo;
        this.recoveryId = recoveryId;
        this.shardId = shardId;
    }

    public long requestSeqNo() {
        return this.requestSeqNo;
    }

    public final long recoveryId() {
        return this.recoveryId;
    }

    public final ShardId shardId() {
        return this.shardId;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.requestSeqNo);
        out.writeLong(this.recoveryId);
        this.shardId.writeTo(out);
    }
}

