/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.identitygovernance;

import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class WorkflowsInsightsByCategory
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public WorkflowsInsightsByCategory() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static WorkflowsInsightsByCategory createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new WorkflowsInsightsByCategory();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Integer getFailedJoinerRuns() {
        return (Integer)this.backingStore.get("failedJoinerRuns");
    }

    @Nullable
    public Integer getFailedLeaverRuns() {
        return (Integer)this.backingStore.get("failedLeaverRuns");
    }

    @Nullable
    public Integer getFailedMoverRuns() {
        return (Integer)this.backingStore.get("failedMoverRuns");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(10);
        deserializerMap.put("failedJoinerRuns", n -> this.setFailedJoinerRuns(n.getIntegerValue()));
        deserializerMap.put("failedLeaverRuns", n -> this.setFailedLeaverRuns(n.getIntegerValue()));
        deserializerMap.put("failedMoverRuns", n -> this.setFailedMoverRuns(n.getIntegerValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("successfulJoinerRuns", n -> this.setSuccessfulJoinerRuns(n.getIntegerValue()));
        deserializerMap.put("successfulLeaverRuns", n -> this.setSuccessfulLeaverRuns(n.getIntegerValue()));
        deserializerMap.put("successfulMoverRuns", n -> this.setSuccessfulMoverRuns(n.getIntegerValue()));
        deserializerMap.put("totalJoinerRuns", n -> this.setTotalJoinerRuns(n.getIntegerValue()));
        deserializerMap.put("totalLeaverRuns", n -> this.setTotalLeaverRuns(n.getIntegerValue()));
        deserializerMap.put("totalMoverRuns", n -> this.setTotalMoverRuns(n.getIntegerValue()));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Integer getSuccessfulJoinerRuns() {
        return (Integer)this.backingStore.get("successfulJoinerRuns");
    }

    @Nullable
    public Integer getSuccessfulLeaverRuns() {
        return (Integer)this.backingStore.get("successfulLeaverRuns");
    }

    @Nullable
    public Integer getSuccessfulMoverRuns() {
        return (Integer)this.backingStore.get("successfulMoverRuns");
    }

    @Nullable
    public Integer getTotalJoinerRuns() {
        return (Integer)this.backingStore.get("totalJoinerRuns");
    }

    @Nullable
    public Integer getTotalLeaverRuns() {
        return (Integer)this.backingStore.get("totalLeaverRuns");
    }

    @Nullable
    public Integer getTotalMoverRuns() {
        return (Integer)this.backingStore.get("totalMoverRuns");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeIntegerValue("failedJoinerRuns", this.getFailedJoinerRuns());
        writer.writeIntegerValue("failedLeaverRuns", this.getFailedLeaverRuns());
        writer.writeIntegerValue("failedMoverRuns", this.getFailedMoverRuns());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeIntegerValue("successfulJoinerRuns", this.getSuccessfulJoinerRuns());
        writer.writeIntegerValue("successfulLeaverRuns", this.getSuccessfulLeaverRuns());
        writer.writeIntegerValue("successfulMoverRuns", this.getSuccessfulMoverRuns());
        writer.writeIntegerValue("totalJoinerRuns", this.getTotalJoinerRuns());
        writer.writeIntegerValue("totalLeaverRuns", this.getTotalLeaverRuns());
        writer.writeIntegerValue("totalMoverRuns", this.getTotalMoverRuns());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setFailedJoinerRuns(@Nullable Integer value) {
        this.backingStore.set("failedJoinerRuns", (Object)value);
    }

    public void setFailedLeaverRuns(@Nullable Integer value) {
        this.backingStore.set("failedLeaverRuns", (Object)value);
    }

    public void setFailedMoverRuns(@Nullable Integer value) {
        this.backingStore.set("failedMoverRuns", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setSuccessfulJoinerRuns(@Nullable Integer value) {
        this.backingStore.set("successfulJoinerRuns", (Object)value);
    }

    public void setSuccessfulLeaverRuns(@Nullable Integer value) {
        this.backingStore.set("successfulLeaverRuns", (Object)value);
    }

    public void setSuccessfulMoverRuns(@Nullable Integer value) {
        this.backingStore.set("successfulMoverRuns", (Object)value);
    }

    public void setTotalJoinerRuns(@Nullable Integer value) {
        this.backingStore.set("totalJoinerRuns", (Object)value);
    }

    public void setTotalLeaverRuns(@Nullable Integer value) {
        this.backingStore.set("totalLeaverRuns", (Object)value);
    }

    public void setTotalMoverRuns(@Nullable Integer value) {
        this.backingStore.set("totalMoverRuns", (Object)value);
    }
}

