/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Entity;
import com.microsoft.graph.models.WindowsDefenderProductStatus;
import com.microsoft.graph.models.WindowsDeviceHealthState;
import com.microsoft.graph.models.WindowsDeviceMalwareState;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class WindowsProtectionState
extends Entity
implements Parsable {
    @Nonnull
    public static WindowsProtectionState createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new WindowsProtectionState();
    }

    @Nullable
    public String getAntiMalwareVersion() {
        return (String)this.backingStore.get("antiMalwareVersion");
    }

    @Nullable
    public List<WindowsDeviceMalwareState> getDetectedMalwareState() {
        return (List)this.backingStore.get("detectedMalwareState");
    }

    @Nullable
    public EnumSet<WindowsDeviceHealthState> getDeviceState() {
        return (EnumSet)this.backingStore.get("deviceState");
    }

    @Nullable
    public String getEngineVersion() {
        return (String)this.backingStore.get("engineVersion");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("antiMalwareVersion", n -> this.setAntiMalwareVersion(n.getStringValue()));
        deserializerMap.put("detectedMalwareState", n -> this.setDetectedMalwareState(n.getCollectionOfObjectValues(WindowsDeviceMalwareState::createFromDiscriminatorValue)));
        deserializerMap.put("deviceState", n -> this.setDeviceState(n.getEnumSetValue(WindowsDeviceHealthState::forValue)));
        deserializerMap.put("engineVersion", n -> this.setEngineVersion(n.getStringValue()));
        deserializerMap.put("fullScanOverdue", n -> this.setFullScanOverdue(n.getBooleanValue()));
        deserializerMap.put("fullScanRequired", n -> this.setFullScanRequired(n.getBooleanValue()));
        deserializerMap.put("isVirtualMachine", n -> this.setIsVirtualMachine(n.getBooleanValue()));
        deserializerMap.put("lastFullScanDateTime", n -> this.setLastFullScanDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("lastFullScanSignatureVersion", n -> this.setLastFullScanSignatureVersion(n.getStringValue()));
        deserializerMap.put("lastQuickScanDateTime", n -> this.setLastQuickScanDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("lastQuickScanSignatureVersion", n -> this.setLastQuickScanSignatureVersion(n.getStringValue()));
        deserializerMap.put("lastReportedDateTime", n -> this.setLastReportedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("malwareProtectionEnabled", n -> this.setMalwareProtectionEnabled(n.getBooleanValue()));
        deserializerMap.put("networkInspectionSystemEnabled", n -> this.setNetworkInspectionSystemEnabled(n.getBooleanValue()));
        deserializerMap.put("productStatus", n -> this.setProductStatus(n.getEnumSetValue(WindowsDefenderProductStatus::forValue)));
        deserializerMap.put("quickScanOverdue", n -> this.setQuickScanOverdue(n.getBooleanValue()));
        deserializerMap.put("realTimeProtectionEnabled", n -> this.setRealTimeProtectionEnabled(n.getBooleanValue()));
        deserializerMap.put("rebootRequired", n -> this.setRebootRequired(n.getBooleanValue()));
        deserializerMap.put("signatureUpdateOverdue", n -> this.setSignatureUpdateOverdue(n.getBooleanValue()));
        deserializerMap.put("signatureVersion", n -> this.setSignatureVersion(n.getStringValue()));
        deserializerMap.put("tamperProtectionEnabled", n -> this.setTamperProtectionEnabled(n.getBooleanValue()));
        return deserializerMap;
    }

    @Nullable
    public Boolean getFullScanOverdue() {
        return (Boolean)this.backingStore.get("fullScanOverdue");
    }

    @Nullable
    public Boolean getFullScanRequired() {
        return (Boolean)this.backingStore.get("fullScanRequired");
    }

    @Nullable
    public Boolean getIsVirtualMachine() {
        return (Boolean)this.backingStore.get("isVirtualMachine");
    }

    @Nullable
    public OffsetDateTime getLastFullScanDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastFullScanDateTime");
    }

    @Nullable
    public String getLastFullScanSignatureVersion() {
        return (String)this.backingStore.get("lastFullScanSignatureVersion");
    }

    @Nullable
    public OffsetDateTime getLastQuickScanDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastQuickScanDateTime");
    }

    @Nullable
    public String getLastQuickScanSignatureVersion() {
        return (String)this.backingStore.get("lastQuickScanSignatureVersion");
    }

    @Nullable
    public OffsetDateTime getLastReportedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastReportedDateTime");
    }

    @Nullable
    public Boolean getMalwareProtectionEnabled() {
        return (Boolean)this.backingStore.get("malwareProtectionEnabled");
    }

    @Nullable
    public Boolean getNetworkInspectionSystemEnabled() {
        return (Boolean)this.backingStore.get("networkInspectionSystemEnabled");
    }

    @Nullable
    public EnumSet<WindowsDefenderProductStatus> getProductStatus() {
        return (EnumSet)this.backingStore.get("productStatus");
    }

    @Nullable
    public Boolean getQuickScanOverdue() {
        return (Boolean)this.backingStore.get("quickScanOverdue");
    }

    @Nullable
    public Boolean getRealTimeProtectionEnabled() {
        return (Boolean)this.backingStore.get("realTimeProtectionEnabled");
    }

    @Nullable
    public Boolean getRebootRequired() {
        return (Boolean)this.backingStore.get("rebootRequired");
    }

    @Nullable
    public Boolean getSignatureUpdateOverdue() {
        return (Boolean)this.backingStore.get("signatureUpdateOverdue");
    }

    @Nullable
    public String getSignatureVersion() {
        return (String)this.backingStore.get("signatureVersion");
    }

    @Nullable
    public Boolean getTamperProtectionEnabled() {
        return (Boolean)this.backingStore.get("tamperProtectionEnabled");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeStringValue("antiMalwareVersion", this.getAntiMalwareVersion());
        writer.writeCollectionOfObjectValues("detectedMalwareState", this.getDetectedMalwareState());
        writer.writeEnumSetValue("deviceState", this.getDeviceState());
        writer.writeStringValue("engineVersion", this.getEngineVersion());
        writer.writeBooleanValue("fullScanOverdue", this.getFullScanOverdue());
        writer.writeBooleanValue("fullScanRequired", this.getFullScanRequired());
        writer.writeBooleanValue("isVirtualMachine", this.getIsVirtualMachine());
        writer.writeOffsetDateTimeValue("lastFullScanDateTime", this.getLastFullScanDateTime());
        writer.writeStringValue("lastFullScanSignatureVersion", this.getLastFullScanSignatureVersion());
        writer.writeOffsetDateTimeValue("lastQuickScanDateTime", this.getLastQuickScanDateTime());
        writer.writeStringValue("lastQuickScanSignatureVersion", this.getLastQuickScanSignatureVersion());
        writer.writeOffsetDateTimeValue("lastReportedDateTime", this.getLastReportedDateTime());
        writer.writeBooleanValue("malwareProtectionEnabled", this.getMalwareProtectionEnabled());
        writer.writeBooleanValue("networkInspectionSystemEnabled", this.getNetworkInspectionSystemEnabled());
        writer.writeEnumSetValue("productStatus", this.getProductStatus());
        writer.writeBooleanValue("quickScanOverdue", this.getQuickScanOverdue());
        writer.writeBooleanValue("realTimeProtectionEnabled", this.getRealTimeProtectionEnabled());
        writer.writeBooleanValue("rebootRequired", this.getRebootRequired());
        writer.writeBooleanValue("signatureUpdateOverdue", this.getSignatureUpdateOverdue());
        writer.writeStringValue("signatureVersion", this.getSignatureVersion());
        writer.writeBooleanValue("tamperProtectionEnabled", this.getTamperProtectionEnabled());
    }

    public void setAntiMalwareVersion(@Nullable String value) {
        this.backingStore.set("antiMalwareVersion", (Object)value);
    }

    public void setDetectedMalwareState(@Nullable List<WindowsDeviceMalwareState> value) {
        this.backingStore.set("detectedMalwareState", value);
    }

    public void setDeviceState(@Nullable EnumSet<WindowsDeviceHealthState> value) {
        this.backingStore.set("deviceState", value);
    }

    public void setEngineVersion(@Nullable String value) {
        this.backingStore.set("engineVersion", (Object)value);
    }

    public void setFullScanOverdue(@Nullable Boolean value) {
        this.backingStore.set("fullScanOverdue", (Object)value);
    }

    public void setFullScanRequired(@Nullable Boolean value) {
        this.backingStore.set("fullScanRequired", (Object)value);
    }

    public void setIsVirtualMachine(@Nullable Boolean value) {
        this.backingStore.set("isVirtualMachine", (Object)value);
    }

    public void setLastFullScanDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastFullScanDateTime", (Object)value);
    }

    public void setLastFullScanSignatureVersion(@Nullable String value) {
        this.backingStore.set("lastFullScanSignatureVersion", (Object)value);
    }

    public void setLastQuickScanDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastQuickScanDateTime", (Object)value);
    }

    public void setLastQuickScanSignatureVersion(@Nullable String value) {
        this.backingStore.set("lastQuickScanSignatureVersion", (Object)value);
    }

    public void setLastReportedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastReportedDateTime", (Object)value);
    }

    public void setMalwareProtectionEnabled(@Nullable Boolean value) {
        this.backingStore.set("malwareProtectionEnabled", (Object)value);
    }

    public void setNetworkInspectionSystemEnabled(@Nullable Boolean value) {
        this.backingStore.set("networkInspectionSystemEnabled", (Object)value);
    }

    public void setProductStatus(@Nullable EnumSet<WindowsDefenderProductStatus> value) {
        this.backingStore.set("productStatus", value);
    }

    public void setQuickScanOverdue(@Nullable Boolean value) {
        this.backingStore.set("quickScanOverdue", (Object)value);
    }

    public void setRealTimeProtectionEnabled(@Nullable Boolean value) {
        this.backingStore.set("realTimeProtectionEnabled", (Object)value);
    }

    public void setRebootRequired(@Nullable Boolean value) {
        this.backingStore.set("rebootRequired", (Object)value);
    }

    public void setSignatureUpdateOverdue(@Nullable Boolean value) {
        this.backingStore.set("signatureUpdateOverdue", (Object)value);
    }

    public void setSignatureVersion(@Nullable String value) {
        this.backingStore.set("signatureVersion", (Object)value);
    }

    public void setTamperProtectionEnabled(@Nullable Boolean value) {
        this.backingStore.set("tamperProtectionEnabled", (Object)value);
    }
}

