/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.CustomTrainingSetting;
import com.microsoft.graph.models.MicrosoftCustomTrainingSetting;
import com.microsoft.graph.models.MicrosoftManagedTrainingSetting;
import com.microsoft.graph.models.MicrosoftTrainingAssignmentMapping;
import com.microsoft.graph.models.NoTrainingSetting;
import com.microsoft.graph.models.TrainingSettingType;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class TrainingSetting
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public TrainingSetting() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static TrainingSetting createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        ParseNode mappingValueNode = parseNode.getChildNode("@odata.type");
        if (mappingValueNode != null) {
            String mappingValue;
            switch (mappingValue = mappingValueNode.getStringValue()) {
                case "#microsoft.graph.customTrainingSetting": {
                    return new CustomTrainingSetting();
                }
                case "#microsoft.graph.microsoftCustomTrainingSetting": {
                    return new MicrosoftCustomTrainingSetting();
                }
                case "#microsoft.graph.microsoftManagedTrainingSetting": {
                    return new MicrosoftManagedTrainingSetting();
                }
                case "#microsoft.graph.microsoftTrainingAssignmentMapping": {
                    return new MicrosoftTrainingAssignmentMapping();
                }
                case "#microsoft.graph.noTrainingSetting": {
                    return new NoTrainingSetting();
                }
            }
        }
        return new TrainingSetting();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(2);
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("settingType", n -> this.setSettingType((TrainingSettingType)n.getEnumValue(TrainingSettingType::forValue)));
        return deserializerMap;
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public TrainingSettingType getSettingType() {
        return (TrainingSettingType)((Object)this.backingStore.get("settingType"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeEnumValue("settingType", (Enum)this.getSettingType());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setSettingType(@Nullable TrainingSettingType value) {
        this.backingStore.set("settingType", (Object)value);
    }
}

