/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ServerProcessedContent;
import com.microsoft.graph.models.TitleAreaLayoutType;
import com.microsoft.graph.models.TitleAreaTextAlignmentType;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class TitleArea
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public TitleArea() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static TitleArea createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new TitleArea();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public String getAlternativeText() {
        return (String)this.backingStore.get("alternativeText");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public Boolean getEnableGradientEffect() {
        return (Boolean)this.backingStore.get("enableGradientEffect");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(11);
        deserializerMap.put("alternativeText", n -> this.setAlternativeText(n.getStringValue()));
        deserializerMap.put("enableGradientEffect", n -> this.setEnableGradientEffect(n.getBooleanValue()));
        deserializerMap.put("imageWebUrl", n -> this.setImageWebUrl(n.getStringValue()));
        deserializerMap.put("layout", n -> this.setLayout((TitleAreaLayoutType)n.getEnumValue(TitleAreaLayoutType::forValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("serverProcessedContent", n -> this.setServerProcessedContent((ServerProcessedContent)n.getObjectValue(ServerProcessedContent::createFromDiscriminatorValue)));
        deserializerMap.put("showAuthor", n -> this.setShowAuthor(n.getBooleanValue()));
        deserializerMap.put("showPublishedDate", n -> this.setShowPublishedDate(n.getBooleanValue()));
        deserializerMap.put("showTextBlockAboveTitle", n -> this.setShowTextBlockAboveTitle(n.getBooleanValue()));
        deserializerMap.put("textAboveTitle", n -> this.setTextAboveTitle(n.getStringValue()));
        deserializerMap.put("textAlignment", n -> this.setTextAlignment((TitleAreaTextAlignmentType)n.getEnumValue(TitleAreaTextAlignmentType::forValue)));
        return deserializerMap;
    }

    @Nullable
    public String getImageWebUrl() {
        return (String)this.backingStore.get("imageWebUrl");
    }

    @Nullable
    public TitleAreaLayoutType getLayout() {
        return (TitleAreaLayoutType)((Object)this.backingStore.get("layout"));
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public ServerProcessedContent getServerProcessedContent() {
        return (ServerProcessedContent)this.backingStore.get("serverProcessedContent");
    }

    @Nullable
    public Boolean getShowAuthor() {
        return (Boolean)this.backingStore.get("showAuthor");
    }

    @Nullable
    public Boolean getShowPublishedDate() {
        return (Boolean)this.backingStore.get("showPublishedDate");
    }

    @Nullable
    public Boolean getShowTextBlockAboveTitle() {
        return (Boolean)this.backingStore.get("showTextBlockAboveTitle");
    }

    @Nullable
    public String getTextAboveTitle() {
        return (String)this.backingStore.get("textAboveTitle");
    }

    @Nullable
    public TitleAreaTextAlignmentType getTextAlignment() {
        return (TitleAreaTextAlignmentType)((Object)this.backingStore.get("textAlignment"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("alternativeText", this.getAlternativeText());
        writer.writeBooleanValue("enableGradientEffect", this.getEnableGradientEffect());
        writer.writeStringValue("imageWebUrl", this.getImageWebUrl());
        writer.writeEnumValue("layout", (Enum)this.getLayout());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeObjectValue("serverProcessedContent", (Parsable)this.getServerProcessedContent(), new Parsable[0]);
        writer.writeBooleanValue("showAuthor", this.getShowAuthor());
        writer.writeBooleanValue("showPublishedDate", this.getShowPublishedDate());
        writer.writeBooleanValue("showTextBlockAboveTitle", this.getShowTextBlockAboveTitle());
        writer.writeStringValue("textAboveTitle", this.getTextAboveTitle());
        writer.writeEnumValue("textAlignment", (Enum)this.getTextAlignment());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAlternativeText(@Nullable String value) {
        this.backingStore.set("alternativeText", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setEnableGradientEffect(@Nullable Boolean value) {
        this.backingStore.set("enableGradientEffect", (Object)value);
    }

    public void setImageWebUrl(@Nullable String value) {
        this.backingStore.set("imageWebUrl", (Object)value);
    }

    public void setLayout(@Nullable TitleAreaLayoutType value) {
        this.backingStore.set("layout", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setServerProcessedContent(@Nullable ServerProcessedContent value) {
        this.backingStore.set("serverProcessedContent", (Object)value);
    }

    public void setShowAuthor(@Nullable Boolean value) {
        this.backingStore.set("showAuthor", (Object)value);
    }

    public void setShowPublishedDate(@Nullable Boolean value) {
        this.backingStore.set("showPublishedDate", (Object)value);
    }

    public void setShowTextBlockAboveTitle(@Nullable Boolean value) {
        this.backingStore.set("showTextBlockAboveTitle", (Object)value);
    }

    public void setTextAboveTitle(@Nullable String value) {
        this.backingStore.set("textAboveTitle", (Object)value);
    }

    public void setTextAlignment(@Nullable TitleAreaTextAlignmentType value) {
        this.backingStore.set("textAlignment", (Object)value);
    }
}

