/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ChangeTrackedEntity;
import com.microsoft.graph.models.ConfirmedBy;
import com.microsoft.graph.models.ItemBody;
import com.microsoft.graph.models.TimeCardBreak;
import com.microsoft.graph.models.TimeCardEntry;
import com.microsoft.graph.models.TimeCardEvent;
import com.microsoft.graph.models.TimeCardState;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class TimeCard
extends ChangeTrackedEntity
implements Parsable {
    public TimeCard() {
        this.setOdataType("#microsoft.graph.timeCard");
    }

    @Nonnull
    public static TimeCard createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new TimeCard();
    }

    @Nullable
    public List<TimeCardBreak> getBreaks() {
        return (List)this.backingStore.get("breaks");
    }

    @Nullable
    public TimeCardEvent getClockInEvent() {
        return (TimeCardEvent)this.backingStore.get("clockInEvent");
    }

    @Nullable
    public TimeCardEvent getClockOutEvent() {
        return (TimeCardEvent)this.backingStore.get("clockOutEvent");
    }

    @Nullable
    public EnumSet<ConfirmedBy> getConfirmedBy() {
        return (EnumSet)this.backingStore.get("confirmedBy");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("breaks", n -> this.setBreaks(n.getCollectionOfObjectValues(TimeCardBreak::createFromDiscriminatorValue)));
        deserializerMap.put("clockInEvent", n -> this.setClockInEvent((TimeCardEvent)n.getObjectValue(TimeCardEvent::createFromDiscriminatorValue)));
        deserializerMap.put("clockOutEvent", n -> this.setClockOutEvent((TimeCardEvent)n.getObjectValue(TimeCardEvent::createFromDiscriminatorValue)));
        deserializerMap.put("confirmedBy", n -> this.setConfirmedBy(n.getEnumSetValue(ConfirmedBy::forValue)));
        deserializerMap.put("notes", n -> this.setNotes((ItemBody)n.getObjectValue(ItemBody::createFromDiscriminatorValue)));
        deserializerMap.put("originalEntry", n -> this.setOriginalEntry((TimeCardEntry)n.getObjectValue(TimeCardEntry::createFromDiscriminatorValue)));
        deserializerMap.put("state", n -> this.setState((TimeCardState)n.getEnumValue(TimeCardState::forValue)));
        deserializerMap.put("userId", n -> this.setUserId(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public ItemBody getNotes() {
        return (ItemBody)this.backingStore.get("notes");
    }

    @Nullable
    public TimeCardEntry getOriginalEntry() {
        return (TimeCardEntry)this.backingStore.get("originalEntry");
    }

    @Nullable
    public TimeCardState getState() {
        return (TimeCardState)((Object)this.backingStore.get("state"));
    }

    @Nullable
    public String getUserId() {
        return (String)this.backingStore.get("userId");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeCollectionOfObjectValues("breaks", this.getBreaks());
        writer.writeObjectValue("clockInEvent", (Parsable)this.getClockInEvent(), new Parsable[0]);
        writer.writeObjectValue("clockOutEvent", (Parsable)this.getClockOutEvent(), new Parsable[0]);
        writer.writeEnumSetValue("confirmedBy", this.getConfirmedBy());
        writer.writeObjectValue("notes", (Parsable)this.getNotes(), new Parsable[0]);
        writer.writeObjectValue("originalEntry", (Parsable)this.getOriginalEntry(), new Parsable[0]);
        writer.writeEnumValue("state", (Enum)this.getState());
        writer.writeStringValue("userId", this.getUserId());
    }

    public void setBreaks(@Nullable List<TimeCardBreak> value) {
        this.backingStore.set("breaks", value);
    }

    public void setClockInEvent(@Nullable TimeCardEvent value) {
        this.backingStore.set("clockInEvent", (Object)value);
    }

    public void setClockOutEvent(@Nullable TimeCardEvent value) {
        this.backingStore.set("clockOutEvent", (Object)value);
    }

    public void setConfirmedBy(@Nullable EnumSet<ConfirmedBy> value) {
        this.backingStore.set("confirmedBy", value);
    }

    public void setNotes(@Nullable ItemBody value) {
        this.backingStore.set("notes", (Object)value);
    }

    public void setOriginalEntry(@Nullable TimeCardEntry value) {
        this.backingStore.set("originalEntry", (Object)value);
    }

    public void setState(@Nullable TimeCardState value) {
        this.backingStore.set("state", (Object)value);
    }

    public void setUserId(@Nullable String value) {
        this.backingStore.set("userId", (Object)value);
    }
}

