/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.MetaDataKeyStringPair;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ServerProcessedContent
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public ServerProcessedContent() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static ServerProcessedContent createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ServerProcessedContent();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("htmlStrings", n -> this.setHtmlStrings(n.getCollectionOfObjectValues(MetaDataKeyStringPair::createFromDiscriminatorValue)));
        deserializerMap.put("imageSources", n -> this.setImageSources(n.getCollectionOfObjectValues(MetaDataKeyStringPair::createFromDiscriminatorValue)));
        deserializerMap.put("links", n -> this.setLinks(n.getCollectionOfObjectValues(MetaDataKeyStringPair::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("searchablePlainTexts", n -> this.setSearchablePlainTexts(n.getCollectionOfObjectValues(MetaDataKeyStringPair::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public List<MetaDataKeyStringPair> getHtmlStrings() {
        return (List)this.backingStore.get("htmlStrings");
    }

    @Nullable
    public List<MetaDataKeyStringPair> getImageSources() {
        return (List)this.backingStore.get("imageSources");
    }

    @Nullable
    public List<MetaDataKeyStringPair> getLinks() {
        return (List)this.backingStore.get("links");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public List<MetaDataKeyStringPair> getSearchablePlainTexts() {
        return (List)this.backingStore.get("searchablePlainTexts");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeCollectionOfObjectValues("htmlStrings", this.getHtmlStrings());
        writer.writeCollectionOfObjectValues("imageSources", this.getImageSources());
        writer.writeCollectionOfObjectValues("links", this.getLinks());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeCollectionOfObjectValues("searchablePlainTexts", this.getSearchablePlainTexts());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setHtmlStrings(@Nullable List<MetaDataKeyStringPair> value) {
        this.backingStore.set("htmlStrings", value);
    }

    public void setImageSources(@Nullable List<MetaDataKeyStringPair> value) {
        this.backingStore.set("imageSources", value);
    }

    public void setLinks(@Nullable List<MetaDataKeyStringPair> value) {
        this.backingStore.set("links", value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setSearchablePlainTexts(@Nullable List<MetaDataKeyStringPair> value) {
        this.backingStore.set("searchablePlainTexts", value);
    }
}

