/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.SelectionLikelihoodInfo;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ScoredEmailAddress
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public ScoredEmailAddress() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static ScoredEmailAddress createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ScoredEmailAddress();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public String getAddress() {
        return (String)this.backingStore.get("address");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(5);
        deserializerMap.put("address", n -> this.setAddress(n.getStringValue()));
        deserializerMap.put("itemId", n -> this.setItemId(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("relevanceScore", n -> this.setRelevanceScore(n.getDoubleValue()));
        deserializerMap.put("selectionLikelihood", n -> this.setSelectionLikelihood((SelectionLikelihoodInfo)n.getEnumValue(SelectionLikelihoodInfo::forValue)));
        return deserializerMap;
    }

    @Nullable
    public String getItemId() {
        return (String)this.backingStore.get("itemId");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public Double getRelevanceScore() {
        return (Double)this.backingStore.get("relevanceScore");
    }

    @Nullable
    public SelectionLikelihoodInfo getSelectionLikelihood() {
        return (SelectionLikelihoodInfo)((Object)this.backingStore.get("selectionLikelihood"));
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("address", this.getAddress());
        writer.writeStringValue("itemId", this.getItemId());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeDoubleValue("relevanceScore", this.getRelevanceScore());
        writer.writeEnumValue("selectionLikelihood", (Enum)this.getSelectionLikelihood());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setAddress(@Nullable String value) {
        this.backingStore.set("address", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setItemId(@Nullable String value) {
        this.backingStore.set("itemId", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setRelevanceScore(@Nullable Double value) {
        this.backingStore.set("relevanceScore", (Object)value);
    }

    public void setSelectionLikelihood(@Nullable SelectionLikelihoodInfo value) {
        this.backingStore.set("selectionLikelihood", (Object)value);
    }
}

