/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.Notebook;
import com.microsoft.graph.models.OnenoteEntitySchemaObjectModel;
import com.microsoft.graph.models.OnenoteSection;
import com.microsoft.graph.models.PageLinks;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class OnenotePage
extends OnenoteEntitySchemaObjectModel
implements Parsable {
    public OnenotePage() {
        this.setOdataType("#microsoft.graph.onenotePage");
    }

    @Nonnull
    public static OnenotePage createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new OnenotePage();
    }

    @Nullable
    public byte[] getContent() {
        return (byte[])this.backingStore.get("content");
    }

    @Nullable
    public String getContentUrl() {
        return (String)this.backingStore.get("contentUrl");
    }

    @Nullable
    public String getCreatedByAppId() {
        return (String)this.backingStore.get("createdByAppId");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("content", n -> this.setContent(n.getByteArrayValue()));
        deserializerMap.put("contentUrl", n -> this.setContentUrl(n.getStringValue()));
        deserializerMap.put("createdByAppId", n -> this.setCreatedByAppId(n.getStringValue()));
        deserializerMap.put("lastModifiedDateTime", n -> this.setLastModifiedDateTime(n.getOffsetDateTimeValue()));
        deserializerMap.put("level", n -> this.setLevel(n.getIntegerValue()));
        deserializerMap.put("links", n -> this.setLinks((PageLinks)n.getObjectValue(PageLinks::createFromDiscriminatorValue)));
        deserializerMap.put("order", n -> this.setOrder(n.getIntegerValue()));
        deserializerMap.put("parentNotebook", n -> this.setParentNotebook((Notebook)n.getObjectValue(Notebook::createFromDiscriminatorValue)));
        deserializerMap.put("parentSection", n -> this.setParentSection((OnenoteSection)n.getObjectValue(OnenoteSection::createFromDiscriminatorValue)));
        deserializerMap.put("title", n -> this.setTitle(n.getStringValue()));
        deserializerMap.put("userTags", n -> this.setUserTags(n.getCollectionOfPrimitiveValues(String.class)));
        return deserializerMap;
    }

    @Nullable
    public OffsetDateTime getLastModifiedDateTime() {
        return (OffsetDateTime)this.backingStore.get("lastModifiedDateTime");
    }

    @Nullable
    public Integer getLevel() {
        return (Integer)this.backingStore.get("level");
    }

    @Nullable
    public PageLinks getLinks() {
        return (PageLinks)this.backingStore.get("links");
    }

    @Nullable
    public Integer getOrder() {
        return (Integer)this.backingStore.get("order");
    }

    @Nullable
    public Notebook getParentNotebook() {
        return (Notebook)this.backingStore.get("parentNotebook");
    }

    @Nullable
    public OnenoteSection getParentSection() {
        return (OnenoteSection)this.backingStore.get("parentSection");
    }

    @Nullable
    public String getTitle() {
        return (String)this.backingStore.get("title");
    }

    @Nullable
    public List<String> getUserTags() {
        return (List)this.backingStore.get("userTags");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writeByteArrayValue("content", this.getContent());
        writer.writeStringValue("contentUrl", this.getContentUrl());
        writer.writeStringValue("createdByAppId", this.getCreatedByAppId());
        writer.writeOffsetDateTimeValue("lastModifiedDateTime", this.getLastModifiedDateTime());
        writer.writeIntegerValue("level", this.getLevel());
        writer.writeObjectValue("links", (Parsable)this.getLinks(), new Parsable[0]);
        writer.writeIntegerValue("order", this.getOrder());
        writer.writeObjectValue("parentNotebook", (Parsable)this.getParentNotebook(), new Parsable[0]);
        writer.writeObjectValue("parentSection", (Parsable)this.getParentSection(), new Parsable[0]);
        writer.writeStringValue("title", this.getTitle());
        writer.writeCollectionOfPrimitiveValues("userTags", this.getUserTags());
    }

    public void setContent(@Nullable byte[] value) {
        this.backingStore.set("content", (Object)value);
    }

    public void setContentUrl(@Nullable String value) {
        this.backingStore.set("contentUrl", (Object)value);
    }

    public void setCreatedByAppId(@Nullable String value) {
        this.backingStore.set("createdByAppId", (Object)value);
    }

    public void setLastModifiedDateTime(@Nullable OffsetDateTime value) {
        this.backingStore.set("lastModifiedDateTime", (Object)value);
    }

    public void setLevel(@Nullable Integer value) {
        this.backingStore.set("level", (Object)value);
    }

    public void setLinks(@Nullable PageLinks value) {
        this.backingStore.set("links", (Object)value);
    }

    public void setOrder(@Nullable Integer value) {
        this.backingStore.set("order", (Object)value);
    }

    public void setParentNotebook(@Nullable Notebook value) {
        this.backingStore.set("parentNotebook", (Object)value);
    }

    public void setParentSection(@Nullable OnenoteSection value) {
        this.backingStore.set("parentSection", (Object)value);
    }

    public void setTitle(@Nullable String value) {
        this.backingStore.set("title", (Object)value);
    }

    public void setUserTags(@Nullable List<String> value) {
        this.backingStore.set("userTags", value);
    }
}

