/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ComplianceStatus;
import com.microsoft.graph.models.SettingSource;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class DeviceCompliancePolicySettingState
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public DeviceCompliancePolicySettingState() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static DeviceCompliancePolicySettingState createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new DeviceCompliancePolicySettingState();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public String getCurrentValue() {
        return (String)this.backingStore.get("currentValue");
    }

    @Nullable
    public Long getErrorCode() {
        return (Long)this.backingStore.get("errorCode");
    }

    @Nullable
    public String getErrorDescription() {
        return (String)this.backingStore.get("errorDescription");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(13);
        deserializerMap.put("currentValue", n -> this.setCurrentValue(n.getStringValue()));
        deserializerMap.put("errorCode", n -> this.setErrorCode(n.getLongValue()));
        deserializerMap.put("errorDescription", n -> this.setErrorDescription(n.getStringValue()));
        deserializerMap.put("instanceDisplayName", n -> this.setInstanceDisplayName(n.getStringValue()));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("setting", n -> this.setSetting(n.getStringValue()));
        deserializerMap.put("settingName", n -> this.setSettingName(n.getStringValue()));
        deserializerMap.put("sources", n -> this.setSources(n.getCollectionOfObjectValues(SettingSource::createFromDiscriminatorValue)));
        deserializerMap.put("state", n -> this.setState((ComplianceStatus)n.getEnumValue(ComplianceStatus::forValue)));
        deserializerMap.put("userEmail", n -> this.setUserEmail(n.getStringValue()));
        deserializerMap.put("userId", n -> this.setUserId(n.getStringValue()));
        deserializerMap.put("userName", n -> this.setUserName(n.getStringValue()));
        deserializerMap.put("userPrincipalName", n -> this.setUserPrincipalName(n.getStringValue()));
        return deserializerMap;
    }

    @Nullable
    public String getInstanceDisplayName() {
        return (String)this.backingStore.get("instanceDisplayName");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public String getSetting() {
        return (String)this.backingStore.get("setting");
    }

    @Nullable
    public String getSettingName() {
        return (String)this.backingStore.get("settingName");
    }

    @Nullable
    public List<SettingSource> getSources() {
        return (List)this.backingStore.get("sources");
    }

    @Nullable
    public ComplianceStatus getState() {
        return (ComplianceStatus)((Object)this.backingStore.get("state"));
    }

    @Nullable
    public String getUserEmail() {
        return (String)this.backingStore.get("userEmail");
    }

    @Nullable
    public String getUserId() {
        return (String)this.backingStore.get("userId");
    }

    @Nullable
    public String getUserName() {
        return (String)this.backingStore.get("userName");
    }

    @Nullable
    public String getUserPrincipalName() {
        return (String)this.backingStore.get("userPrincipalName");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeStringValue("currentValue", this.getCurrentValue());
        writer.writeLongValue("errorCode", this.getErrorCode());
        writer.writeStringValue("errorDescription", this.getErrorDescription());
        writer.writeStringValue("instanceDisplayName", this.getInstanceDisplayName());
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeStringValue("setting", this.getSetting());
        writer.writeStringValue("settingName", this.getSettingName());
        writer.writeCollectionOfObjectValues("sources", this.getSources());
        writer.writeEnumValue("state", (Enum)this.getState());
        writer.writeStringValue("userEmail", this.getUserEmail());
        writer.writeStringValue("userId", this.getUserId());
        writer.writeStringValue("userName", this.getUserName());
        writer.writeStringValue("userPrincipalName", this.getUserPrincipalName());
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setCurrentValue(@Nullable String value) {
        this.backingStore.set("currentValue", (Object)value);
    }

    public void setErrorCode(@Nullable Long value) {
        this.backingStore.set("errorCode", (Object)value);
    }

    public void setErrorDescription(@Nullable String value) {
        this.backingStore.set("errorDescription", (Object)value);
    }

    public void setInstanceDisplayName(@Nullable String value) {
        this.backingStore.set("instanceDisplayName", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setSetting(@Nullable String value) {
        this.backingStore.set("setting", (Object)value);
    }

    public void setSettingName(@Nullable String value) {
        this.backingStore.set("settingName", (Object)value);
    }

    public void setSources(@Nullable List<SettingSource> value) {
        this.backingStore.set("sources", value);
    }

    public void setState(@Nullable ComplianceStatus value) {
        this.backingStore.set("state", (Object)value);
    }

    public void setUserEmail(@Nullable String value) {
        this.backingStore.set("userEmail", (Object)value);
    }

    public void setUserId(@Nullable String value) {
        this.backingStore.set("userId", (Object)value);
    }

    public void setUserName(@Nullable String value) {
        this.backingStore.set("userName", (Object)value);
    }

    public void setUserPrincipalName(@Nullable String value) {
        this.backingStore.set("userPrincipalName", (Object)value);
    }
}

