/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.ConditionalAccessApplications;
import com.microsoft.graph.models.ConditionalAccessAuthenticationFlows;
import com.microsoft.graph.models.ConditionalAccessClientApp;
import com.microsoft.graph.models.ConditionalAccessClientApplications;
import com.microsoft.graph.models.ConditionalAccessDevices;
import com.microsoft.graph.models.ConditionalAccessInsiderRiskLevels;
import com.microsoft.graph.models.ConditionalAccessLocations;
import com.microsoft.graph.models.ConditionalAccessPlatforms;
import com.microsoft.graph.models.ConditionalAccessUsers;
import com.microsoft.graph.models.RiskLevel;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.store.BackedModel;
import com.microsoft.kiota.store.BackingStore;
import com.microsoft.kiota.store.BackingStoreFactorySingleton;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class ConditionalAccessConditionSet
implements AdditionalDataHolder,
BackedModel,
Parsable {
    @Nonnull
    protected BackingStore backingStore = BackingStoreFactorySingleton.instance.createBackingStore();

    public ConditionalAccessConditionSet() {
        this.setAdditionalData(new HashMap<String, Object>());
    }

    @Nonnull
    public static ConditionalAccessConditionSet createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new ConditionalAccessConditionSet();
    }

    @Nonnull
    public Map<String, Object> getAdditionalData() {
        HashMap<String, Object> value = (HashMap<String, Object>)this.backingStore.get("additionalData");
        if (value == null) {
            value = new HashMap<String, Object>();
            this.setAdditionalData(value);
        }
        return value;
    }

    @Nullable
    public ConditionalAccessApplications getApplications() {
        return (ConditionalAccessApplications)this.backingStore.get("applications");
    }

    @Nullable
    public ConditionalAccessAuthenticationFlows getAuthenticationFlows() {
        return (ConditionalAccessAuthenticationFlows)this.backingStore.get("authenticationFlows");
    }

    @Nonnull
    public BackingStore getBackingStore() {
        return this.backingStore;
    }

    @Nullable
    public ConditionalAccessClientApplications getClientApplications() {
        return (ConditionalAccessClientApplications)this.backingStore.get("clientApplications");
    }

    @Nullable
    public List<ConditionalAccessClientApp> getClientAppTypes() {
        return (List)this.backingStore.get("clientAppTypes");
    }

    @Nullable
    public ConditionalAccessDevices getDevices() {
        return (ConditionalAccessDevices)this.backingStore.get("devices");
    }

    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(13);
        deserializerMap.put("applications", n -> this.setApplications((ConditionalAccessApplications)n.getObjectValue(ConditionalAccessApplications::createFromDiscriminatorValue)));
        deserializerMap.put("authenticationFlows", n -> this.setAuthenticationFlows((ConditionalAccessAuthenticationFlows)n.getObjectValue(ConditionalAccessAuthenticationFlows::createFromDiscriminatorValue)));
        deserializerMap.put("clientApplications", n -> this.setClientApplications((ConditionalAccessClientApplications)n.getObjectValue(ConditionalAccessClientApplications::createFromDiscriminatorValue)));
        deserializerMap.put("clientAppTypes", n -> this.setClientAppTypes(n.getCollectionOfEnumValues(ConditionalAccessClientApp::forValue)));
        deserializerMap.put("devices", n -> this.setDevices((ConditionalAccessDevices)n.getObjectValue(ConditionalAccessDevices::createFromDiscriminatorValue)));
        deserializerMap.put("insiderRiskLevels", n -> this.setInsiderRiskLevels(n.getEnumSetValue(ConditionalAccessInsiderRiskLevels::forValue)));
        deserializerMap.put("locations", n -> this.setLocations((ConditionalAccessLocations)n.getObjectValue(ConditionalAccessLocations::createFromDiscriminatorValue)));
        deserializerMap.put("@odata.type", n -> this.setOdataType(n.getStringValue()));
        deserializerMap.put("platforms", n -> this.setPlatforms((ConditionalAccessPlatforms)n.getObjectValue(ConditionalAccessPlatforms::createFromDiscriminatorValue)));
        deserializerMap.put("servicePrincipalRiskLevels", n -> this.setServicePrincipalRiskLevels(n.getCollectionOfEnumValues(RiskLevel::forValue)));
        deserializerMap.put("signInRiskLevels", n -> this.setSignInRiskLevels(n.getCollectionOfEnumValues(RiskLevel::forValue)));
        deserializerMap.put("userRiskLevels", n -> this.setUserRiskLevels(n.getCollectionOfEnumValues(RiskLevel::forValue)));
        deserializerMap.put("users", n -> this.setUsers((ConditionalAccessUsers)n.getObjectValue(ConditionalAccessUsers::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public EnumSet<ConditionalAccessInsiderRiskLevels> getInsiderRiskLevels() {
        return (EnumSet)this.backingStore.get("insiderRiskLevels");
    }

    @Nullable
    public ConditionalAccessLocations getLocations() {
        return (ConditionalAccessLocations)this.backingStore.get("locations");
    }

    @Nullable
    public String getOdataType() {
        return (String)this.backingStore.get("odataType");
    }

    @Nullable
    public ConditionalAccessPlatforms getPlatforms() {
        return (ConditionalAccessPlatforms)this.backingStore.get("platforms");
    }

    @Nullable
    public List<RiskLevel> getServicePrincipalRiskLevels() {
        return (List)this.backingStore.get("servicePrincipalRiskLevels");
    }

    @Nullable
    public List<RiskLevel> getSignInRiskLevels() {
        return (List)this.backingStore.get("signInRiskLevels");
    }

    @Nullable
    public List<RiskLevel> getUserRiskLevels() {
        return (List)this.backingStore.get("userRiskLevels");
    }

    @Nullable
    public ConditionalAccessUsers getUsers() {
        return (ConditionalAccessUsers)this.backingStore.get("users");
    }

    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        writer.writeObjectValue("applications", (Parsable)this.getApplications(), new Parsable[0]);
        writer.writeObjectValue("authenticationFlows", (Parsable)this.getAuthenticationFlows(), new Parsable[0]);
        writer.writeObjectValue("clientApplications", (Parsable)this.getClientApplications(), new Parsable[0]);
        writer.writeCollectionOfEnumValues("clientAppTypes", this.getClientAppTypes());
        writer.writeObjectValue("devices", (Parsable)this.getDevices(), new Parsable[0]);
        writer.writeEnumSetValue("insiderRiskLevels", this.getInsiderRiskLevels());
        writer.writeObjectValue("locations", (Parsable)this.getLocations(), new Parsable[0]);
        writer.writeStringValue("@odata.type", this.getOdataType());
        writer.writeObjectValue("platforms", (Parsable)this.getPlatforms(), new Parsable[0]);
        writer.writeCollectionOfEnumValues("servicePrincipalRiskLevels", this.getServicePrincipalRiskLevels());
        writer.writeCollectionOfEnumValues("signInRiskLevels", this.getSignInRiskLevels());
        writer.writeCollectionOfEnumValues("userRiskLevels", this.getUserRiskLevels());
        writer.writeObjectValue("users", (Parsable)this.getUsers(), new Parsable[0]);
        writer.writeAdditionalData(this.getAdditionalData());
    }

    public void setAdditionalData(@Nullable Map<String, Object> value) {
        this.backingStore.set("additionalData", value);
    }

    public void setApplications(@Nullable ConditionalAccessApplications value) {
        this.backingStore.set("applications", (Object)value);
    }

    public void setAuthenticationFlows(@Nullable ConditionalAccessAuthenticationFlows value) {
        this.backingStore.set("authenticationFlows", (Object)value);
    }

    public void setBackingStore(@Nonnull BackingStore value) {
        Objects.requireNonNull(value);
        this.backingStore = value;
    }

    public void setClientApplications(@Nullable ConditionalAccessClientApplications value) {
        this.backingStore.set("clientApplications", (Object)value);
    }

    public void setClientAppTypes(@Nullable List<ConditionalAccessClientApp> value) {
        this.backingStore.set("clientAppTypes", value);
    }

    public void setDevices(@Nullable ConditionalAccessDevices value) {
        this.backingStore.set("devices", (Object)value);
    }

    public void setInsiderRiskLevels(@Nullable EnumSet<ConditionalAccessInsiderRiskLevels> value) {
        this.backingStore.set("insiderRiskLevels", value);
    }

    public void setLocations(@Nullable ConditionalAccessLocations value) {
        this.backingStore.set("locations", (Object)value);
    }

    public void setOdataType(@Nullable String value) {
        this.backingStore.set("odataType", (Object)value);
    }

    public void setPlatforms(@Nullable ConditionalAccessPlatforms value) {
        this.backingStore.set("platforms", (Object)value);
    }

    public void setServicePrincipalRiskLevels(@Nullable List<RiskLevel> value) {
        this.backingStore.set("servicePrincipalRiskLevels", value);
    }

    public void setSignInRiskLevels(@Nullable List<RiskLevel> value) {
        this.backingStore.set("signInRiskLevels", value);
    }

    public void setUserRiskLevels(@Nullable List<RiskLevel> value) {
        this.backingStore.set("userRiskLevels", value);
    }

    public void setUsers(@Nullable ConditionalAccessUsers value) {
        this.backingStore.set("users", (Object)value);
    }
}

