/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models;

import com.microsoft.graph.models.CallParticipantInfo;
import com.microsoft.graph.models.EventMessageDetail;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.TeamworkCallEventType;
import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.SerializationWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class CallEndedEventMessageDetail
extends EventMessageDetail
implements Parsable {
    public CallEndedEventMessageDetail() {
        this.setOdataType("#microsoft.graph.callEndedEventMessageDetail");
    }

    @Nonnull
    public static CallEndedEventMessageDetail createFromDiscriminatorValue(@Nonnull ParseNode parseNode) {
        Objects.requireNonNull(parseNode);
        return new CallEndedEventMessageDetail();
    }

    @Nullable
    public PeriodAndDuration getCallDuration() {
        return (PeriodAndDuration)this.backingStore.get("callDuration");
    }

    @Nullable
    public TeamworkCallEventType getCallEventType() {
        return (TeamworkCallEventType)((Object)this.backingStore.get("callEventType"));
    }

    @Nullable
    public String getCallId() {
        return (String)this.backingStore.get("callId");
    }

    @Nullable
    public List<CallParticipantInfo> getCallParticipants() {
        return (List)this.backingStore.get("callParticipants");
    }

    @Override
    @Nonnull
    public Map<String, Consumer<ParseNode>> getFieldDeserializers() {
        HashMap<String, Consumer<ParseNode>> deserializerMap = new HashMap<String, Consumer<ParseNode>>(super.getFieldDeserializers());
        deserializerMap.put("callDuration", n -> this.setCallDuration(n.getPeriodAndDurationValue()));
        deserializerMap.put("callEventType", n -> this.setCallEventType((TeamworkCallEventType)n.getEnumValue(TeamworkCallEventType::forValue)));
        deserializerMap.put("callId", n -> this.setCallId(n.getStringValue()));
        deserializerMap.put("callParticipants", n -> this.setCallParticipants(n.getCollectionOfObjectValues(CallParticipantInfo::createFromDiscriminatorValue)));
        deserializerMap.put("initiator", n -> this.setInitiator((IdentitySet)n.getObjectValue(IdentitySet::createFromDiscriminatorValue)));
        return deserializerMap;
    }

    @Nullable
    public IdentitySet getInitiator() {
        return (IdentitySet)this.backingStore.get("initiator");
    }

    @Override
    public void serialize(@Nonnull SerializationWriter writer) {
        Objects.requireNonNull(writer);
        super.serialize(writer);
        writer.writePeriodAndDurationValue("callDuration", this.getCallDuration());
        writer.writeEnumValue("callEventType", (Enum)this.getCallEventType());
        writer.writeStringValue("callId", this.getCallId());
        writer.writeCollectionOfObjectValues("callParticipants", this.getCallParticipants());
        writer.writeObjectValue("initiator", (Parsable)this.getInitiator(), new Parsable[0]);
    }

    public void setCallDuration(@Nullable PeriodAndDuration value) {
        this.backingStore.set("callDuration", (Object)value);
    }

    public void setCallEventType(@Nullable TeamworkCallEventType value) {
        this.backingStore.set("callEventType", (Object)value);
    }

    public void setCallId(@Nullable String value) {
        this.backingStore.set("callId", (Object)value);
    }

    public void setCallParticipants(@Nullable List<CallParticipantInfo> value) {
        this.backingStore.set("callParticipants", value);
    }

    public void setInitiator(@Nullable IdentitySet value) {
        this.backingStore.set("initiator", (Object)value);
    }
}

