/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.ec2;

import java.io.Closeable;
import java.util.List;
import java.util.function.Function;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.discovery.ec2.AmazonEc2Reference;
import org.elasticsearch.discovery.ec2.Ec2ClientSettings;

interface AwsEc2Service
extends Closeable {
    public static final Setting<Boolean> AUTO_ATTRIBUTE_SETTING = Setting.boolSetting((String)"cloud.node.auto_attributes", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<String> HOST_TYPE_SETTING = new Setting("discovery.ec2.host_type", "private_ip", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Boolean> ANY_GROUP_SETTING = Setting.boolSetting((String)"discovery.ec2.any_group", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<List<String>> GROUPS_SETTING = Setting.stringListSetting((String)"discovery.ec2.groups", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<List<String>> AVAILABILITY_ZONES_SETTING = Setting.stringListSetting((String)"discovery.ec2.availability_zones", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> NODE_CACHE_TIME_SETTING = Setting.timeSetting((String)"discovery.ec2.node_cache_time", (TimeValue)TimeValue.timeValueSeconds((long)10L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting.AffixSetting<List<String>> TAG_SETTING = Setting.prefixKeySetting((String)"discovery.ec2.tag.", key -> Setting.stringListSetting((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));

    public AmazonEc2Reference client();

    public void refreshAndClearCache(Ec2ClientSettings var1);

    public static class HostType {
        public static final String PRIVATE_IP = "private_ip";
        public static final String PUBLIC_IP = "public_ip";
        public static final String PRIVATE_DNS = "private_dns";
        public static final String PUBLIC_DNS = "public_dns";
        public static final String TAG_PREFIX = "tag:";
    }
}

